import{_ as de}from"./LoadingCircular.vue.71074e6f.js";import{_ as H}from"./TextInput.vue.bbeebcbb.js";import{_ as pe}from"./Select.vue.92557306.js";import{k as P,p as b,o as a,b as l,e as i,F as y,u as e,G as x,J as Q,v as q,c8 as fe,c9 as X,r as V,w as _,q as K,c as f,B as I,z as W,A as w,c4 as $,D as we,C as Te,W as ge,a8 as be,s as he,y as ve,a0 as ye,X as Ce}from"./entry.91d7abef.js";import{_ as ee}from"./Alert.vue.cc337c06.js";import{_ as Oe}from"./Button.vue.c959fee1.js";import{_ as Ue}from"./Modal.0af5d144.js";import{u as te}from"./useAsyncValidator.5964f3ff.js";import{A as z}from"./alertTypes.e75dff9a.js";import{B as ke}from"./buttonType.13ac0b96.js";import"./Icon.6cd449a6.js";import"./inputTypes.47a10ae0.js";import"./Button.vue.32849234.js";import"./nuxt-link.b49d884c.js";/* empty css                  */const Le={key:0},Ie=i("p",{class:"pb-2 text-sm"}," This server requires two-factor authentication with TOTP (time-based one-time passwords). ",-1),qe={class:"pb-2 text-sm"},Re=["href"],Ge={class:"my-6 flex items-start justify-between"},Ke={class:"flex min-h-[60px] items-center justify-center"},Se={class:"text-center"},Be=i("span",{class:"rounded-full bg-slate-100 px-3 py-1 text-sm"}," Free ",-1),De=["src"],Fe=["href"],Ve=["src","srcset"],We=i("p",{class:"text-sm"}," If you have an authenticator app or a token generator installed, proceed to the initial setup. ",-1),xe={key:1},Ye=i("p",{class:"pb-2 text-sm"}," Scan the QR code with your app or enter the displayed secret manually. ",-1),Me={class:"flex h-[200px] justify-center"},Ne=["src"],Ee={class:"mt-4 flex justify-center"},Qe={class:"rounded bg-slate-50 px-4 py-1"},ze=P({__name:"TimeBasedOneTimePasswords",props:{totpHasBeenCreated:{type:Boolean},totpQrCode:{},totpSecret:{}},setup(T){const O=b(`${fe().public.knowledgeBaseUrl}/log-in-with-2fa#totp-time-bases-one-time-passwords`),U=b([{name:"Google Authenticator",icon:new URL(""+new URL("google-authenticator.08a6fcc5.svg",import.meta.url).href,self.location).href,stores:[{icon:new URL("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJYAAAAtCAMAAAB70mJmAAAABGdBTUEAALGPC/xhBQAAAAFzUkdCAK7OHOkAAAMAUExURZ+fn6Ojo7m5uampqaqqqqysrH5+fkdwTJ2dnampqbGxsZ+fn729vcHBwYmJibW1tbu7u7S0tKurq8bGxo2NjbOzswAAACcnJwABAf///zo6OgMCAv7+/iAgIAUGBSQkJPPz8wDyeGlpaTQ0NBEREefn5wDg/05OThcXFwDW/0pKSgkJCQsLC6Ojo/Ly8gDG+/r6+lJSUp+fnzIyMg0NDcLCwiwsLCgoKADa/wDJ/4mJibi4uPv7+7u7u2xsbL+/vwDL/wDG/5OTk9DQ0Onp6RsbG39/f//OAADQ/wDN/wDwd2ZlZUZGRu7u7hQUFADR/wDU/4eHhwDvfWNjY1RUVPb29jc3N6ysrOXl5cHBwf39/Y+Pj4SEhADX/9PT0/Dw8ADj/6ioqFtbWr6+vqampgcHB8/Pz7W1tcvLy25ubsbGxv40QwDc/z09Pa+vr0BAQHx8fPErShAQEHJycoyMjMnJybOzs5ubm/X19V9fX3h4eK6urv/KAEhISIKCgl1dXfcwRgCnvTAwMGFhYTw8PCIiIoaGhhkZGfj4+NbW1uzs7ACevf/TAP/HAADzeQDbvvsyRADd//QuRwDm/2yMr6urq3V1dcTExNra2nl5eUJCQuLi4gCjvQCmvWjfRP/EAACYvf9yI/84QgDavwHsd+4mTVZWVrCwsNzc3N/f31hYWJiYmG5dAf/ZAO/HAvrOAP+7AQbSb3eGqAHUwQHnewLV+YoSKXKKq+YkTNwsWAHa+uIwVdjY2MjIyGJiYgsIAO/MAL2iAu0vQQHjdANGJASxXQEZCgV7QQIsFnuDp0AFDe02T9gnQACTvaocMVgKFhMBAguOTgTffSUCBr0fOAGDmuk0UQHd+gRjNBwrB2RSABoUAB4YAf/eAE9BAS0VAs2nANOuAohuA7iZANa4Bkk8AATFZwqZT4BoAHYRH9+pAZgeJe25BAaXUHKpeQItKO85TfM/S/I6TALP+QLC8wRgMw6WXgHQvwDvdgRAIgXCZocfOG0NIDkEDNMeRsUfQeLjLxgAAAAWdFJOU+ngE8Gsj/kA+tF08BQK8VMiabQH7EUXij1RAAAHMUlEQVRYw82ZeVwaRxTHTZvU3ncnOy6sFCFQQSJ3ytmikFaBxiKIYCCCEkxr8MRoGkw1RKBXmoYYY5teOWrSpm3aXK1N7zttk/S+7/u+72N2I1WiqPmUTz+8P2TdnTf7Zeb33psZsrKzjz/l1ClZGWNTpp50QnZ2VvbJU4/K75JPzxCTi4UnTjsiO+v4qaU8kFFmXj3ttKxjj6oFGWbc08/IOnItyDjrnJZ1nDzzsAJHZh09PfOwco5JwsKwiV3oYjoGcDo9zOXTkREA8PmSMLrC0UNCLjYDgPdgADNj6cL6+qf9v07QGS/Uq5Y2YGuLent13VKXS8oBoKOubkHUp+wCIFwg9Wo9YG0RB+jj9HRhvXjXgTv3PzGuQ0NlvcRmwYRqWW6PRF4jmo6Si8Ig6dIawgQg4qIwq9Mf4Ji8LHpvbpqwsGfO/vnA3Xc+/ljq9k1odIimJkKoFstYAOjKyJsKA8A37UEXyxaQI6TYIlRvMoSlacSaedfd69f/9iORqr0evcyi1oo6+9VqC8JSJLCC6D/ACZL6YsY98UCvpTJtWDeccy7i+uXM9Y8+kkJifO1mwJIblN1BrgQfhWVrJfvSOYUVeIPPlz6s888+d+bNF5aUXPnwlykkpmkV6o1ajVAbyJEnsFoSWLhok43e7M/jLMbMvfb0YZ13zhBXyZkpJIZrvFptB56jnq9swUEzk7zH3AMwRT5VNZyV2mA+qF+OgfzqnrRhXXD+MFfJR6+MKTEJHWkdq+Xx0FMcp1DRX/zgrGNcOqqwGJXC0pVOscvmnDfMVTKOxP7XLI9ddtYFI7mQxD5+NROw5s5J5ipZ98F7b4zhRhD/K9asOUlcv6zbesnsd2+9/5BVWrdI7a3RTKK20MttyZWLU44sn/SUbxQfBtZZSVzrtl5xyezLb3/wrZEuQr8KqlTQ4fJMKDymKp7URhwrVDkchQMhHghB0aSxrr147jDXVReu23o9wpp9+W0P3DrsYYlBV1W5sKFVVT3hTGrgwiSsPLdVWVHhFaicYDksmDzW1bOGuX746ovrh7DefBBPtKm30wqo6eMyJ57FUVgCO3oZwWTExFWHgzVj1r9cM5/89sY7Ro0WHodq1qSVOwZWmAwYLbSEDgvr4gTXzCe/u+imG++gtPX+h/+2lxVbhckxmV/lXC2jvMUdzpCRGlY902mwBcqbmCQWwSlz7mElYXmHsMR9W1rKebhxI53qaaN+bKzr5l09xPX9tm9WrCC5Zt/+zmsjInGjYw2XQliGrF4GuAUMCGG/Bq1XO9joStCGAIw+B4T2YoaRxDLXWCFNpc4dwkKfeLvbZEOTiFnsyCNSrS+AOvTQaLLnpcKaQXHN/X7b0ytWUFyfffJ6UmxBP7l94/oYAoFbUMltg/1VpTVWdzmwMBiiUoWd5gTTozS1piMKI/lMuJjQwYGGTiWsICjJL1rcJgqaaFswJHmeKFbQ3jAADRzrLWi42mA1nhKL4tq+7emlS5cirIc+fzt50j20qJlMXco1g4N26BPGTGjRjOugsqcXlqFePQy7LAS1qE09m8SqkNndHNxWTTMFKCw0PNDBdrJAGZrEWo7Qw6lySHu8sA7QB6wckBoLcW3f+dLKlQjroWefOlSL4tgiaqnA4nLNzVC9GnrJUchxDwjZMVJh/FaHZT7UkMERVCGseHkkqgm6GVpNE4Vl6mvv3ixDcUBiBbQMRyQGi2pLaVpCAyt5KbAuJbFm3LPzpcbGlUtXvvAcPrrqBOGmIW+8Biqa4Xwy1Lpi/Z5YIsjqvLCTfF5NYXkihVa7aAkxUvKklUERvYim7lithEU8rouxWQ2ZqSLx0msoqnsbEdbeT/eNFbpLYiodFVZE36Ji25LIALn5raO1yqKqbvLFbHegDbYhVr2rkJzEZTEoQjKnN43G4kQGUejVISyU812CaE9qrHnz7ll174bGxr07nh87o2DNbpW0LlDfvtAaMQCJFioDuaX9jj6ggLe05xor4XzCaBKEZEhOlOR5FdAbCG92KfWjsNYK2J7c9gHo4wNZP4TLwThYLyOqDbuQqPAUmQ6zDNJoVqsDshvQzNRHoYBdWFggAebFqgibAf1igBkEjpgpEiGxFgKZHwrsVlV106FYBfw4tBZbix1FfDIM7V3jYL28aveGXWOJaoSFO4J+v7fFRiVweUuvT8nkk3u1ZqVPWka+FhMu9Gn7/BFjThvSS3i51Keuk1BpVqdIlAiOqBtwQ1L/Fo6uAb2tBYqw1FjzVu3e9fcf+yYqKjifP1ymayWJL0EcvIuL83A+bna5E9mRkKQq6gT/IIw+yjCOs6tetfuvVKKavNX3DxoJSUh1n2TSLijXEKmxuL/v+PO/Ly0lcVpMWhRxt0/ag4Wy3TilOk0bCnPLGndsQefke8tT1pjHO0hKl+nzZPzDaI4R+KiFTYaeBmbo2WmGnjRn6Ll8hv6KkZm/+fwDABHg2TnpuNoAAAAASUVORK5CYII=",self.location).href,icon2x:new URL(""+new URL("google-play-2x.70382080.png",import.meta.url).href,self.location).href,link:"https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=en_US&gl=US"},{icon:new URL("data:image/png;base64,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",self.location).href,icon2x:new URL(""+new URL("apple-app-store-2x.794e0a2f.png",import.meta.url).href,self.location).href,link:"https://apps.apple.com/us/app/google-authenticator/id388497605"}]},{name:"Microsoft Authenticator",icon:new URL(""+new URL("microsoft-authenticator.e9deb94c.svg",import.meta.url).href,self.location).href,stores:[{icon:new URL("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJYAAAAtCAMAAAB70mJmAAAABGdBTUEAALGPC/xhBQAAAAFzUkdCAK7OHOkAAAMAUExURZ+fn6Ojo7m5uampqaqqqqysrH5+fkdwTJ2dnampqbGxsZ+fn729vcHBwYmJibW1tbu7u7S0tKurq8bGxo2NjbOzswAAACcnJwABAf///zo6OgMCAv7+/iAgIAUGBSQkJPPz8wDyeGlpaTQ0NBEREefn5wDg/05OThcXFwDW/0pKSgkJCQsLC6Ojo/Ly8gDG+/r6+lJSUp+fnzIyMg0NDcLCwiwsLCgoKADa/wDJ/4mJibi4uPv7+7u7u2xsbL+/vwDL/wDG/5OTk9DQ0Onp6RsbG39/f//OAADQ/wDN/wDwd2ZlZUZGRu7u7hQUFADR/wDU/4eHhwDvfWNjY1RUVPb29jc3N6ysrOXl5cHBwf39/Y+Pj4SEhADX/9PT0/Dw8ADj/6ioqFtbWr6+vqampgcHB8/Pz7W1tcvLy25ubsbGxv40QwDc/z09Pa+vr0BAQHx8fPErShAQEHJycoyMjMnJybOzs5ubm/X19V9fX3h4eK6urv/KAEhISIKCgl1dXfcwRgCnvTAwMGFhYTw8PCIiIoaGhhkZGfj4+NbW1uzs7ACevf/TAP/HAADzeQDbvvsyRADd//QuRwDm/2yMr6urq3V1dcTExNra2nl5eUJCQuLi4gCjvQCmvWjfRP/EAACYvf9yI/84QgDavwHsd+4mTVZWVrCwsNzc3N/f31hYWJiYmG5dAf/ZAO/HAvrOAP+7AQbSb3eGqAHUwQHnewLV+YoSKXKKq+YkTNwsWAHa+uIwVdjY2MjIyGJiYgsIAO/MAL2iAu0vQQHjdANGJASxXQEZCgV7QQIsFnuDp0AFDe02T9gnQACTvaocMVgKFhMBAguOTgTffSUCBr0fOAGDmuk0UQHd+gRjNBwrB2RSABoUAB4YAf/eAE9BAS0VAs2nANOuAohuA7iZANa4Bkk8AATFZwqZT4BoAHYRH9+pAZgeJe25BAaXUHKpeQItKO85TfM/S/I6TALP+QLC8wRgMw6WXgHQvwDvdgRAIgXCZocfOG0NIDkEDNMeRsUfQeLjLxgAAAAWdFJOU+ngE8Gsj/kA+tF08BQK8VMiabQH7EUXij1RAAAHMUlEQVRYw82ZeVwaRxTHTZvU3ncnOy6sFCFQQSJ3ytmikFaBxiKIYCCCEkxr8MRoGkw1RKBXmoYYY5teOWrSpm3aXK1N7zttk/S+7/u+72N2I1WiqPmUTz+8P2TdnTf7Zeb33psZsrKzjz/l1ClZGWNTpp50QnZ2VvbJU4/K75JPzxCTi4UnTjsiO+v4qaU8kFFmXj3ttKxjj6oFGWbc08/IOnItyDjrnJZ1nDzzsAJHZh09PfOwco5JwsKwiV3oYjoGcDo9zOXTkREA8PmSMLrC0UNCLjYDgPdgADNj6cL6+qf9v07QGS/Uq5Y2YGuLent13VKXS8oBoKOubkHUp+wCIFwg9Wo9YG0RB+jj9HRhvXjXgTv3PzGuQ0NlvcRmwYRqWW6PRF4jmo6Si8Ig6dIawgQg4qIwq9Mf4Ji8LHpvbpqwsGfO/vnA3Xc+/ljq9k1odIimJkKoFstYAOjKyJsKA8A37UEXyxaQI6TYIlRvMoSlacSaedfd69f/9iORqr0evcyi1oo6+9VqC8JSJLCC6D/ACZL6YsY98UCvpTJtWDeccy7i+uXM9Y8+kkJifO1mwJIblN1BrgQfhWVrJfvSOYUVeIPPlz6s888+d+bNF5aUXPnwlykkpmkV6o1ajVAbyJEnsFoSWLhok43e7M/jLMbMvfb0YZ13zhBXyZkpJIZrvFptB56jnq9swUEzk7zH3AMwRT5VNZyV2mA+qF+OgfzqnrRhXXD+MFfJR6+MKTEJHWkdq+Xx0FMcp1DRX/zgrGNcOqqwGJXC0pVOscvmnDfMVTKOxP7XLI9ddtYFI7mQxD5+NROw5s5J5ipZ98F7b4zhRhD/K9asOUlcv6zbesnsd2+9/5BVWrdI7a3RTKK20MttyZWLU44sn/SUbxQfBtZZSVzrtl5xyezLb3/wrZEuQr8KqlTQ4fJMKDymKp7URhwrVDkchQMhHghB0aSxrr147jDXVReu23o9wpp9+W0P3DrsYYlBV1W5sKFVVT3hTGrgwiSsPLdVWVHhFaicYDksmDzW1bOGuX746ovrh7DefBBPtKm30wqo6eMyJ57FUVgCO3oZwWTExFWHgzVj1r9cM5/89sY7Ro0WHodq1qSVOwZWmAwYLbSEDgvr4gTXzCe/u+imG++gtPX+h/+2lxVbhckxmV/lXC2jvMUdzpCRGlY902mwBcqbmCQWwSlz7mElYXmHsMR9W1rKebhxI53qaaN+bKzr5l09xPX9tm9WrCC5Zt/+zmsjInGjYw2XQliGrF4GuAUMCGG/Bq1XO9joStCGAIw+B4T2YoaRxDLXWCFNpc4dwkKfeLvbZEOTiFnsyCNSrS+AOvTQaLLnpcKaQXHN/X7b0ytWUFyfffJ6UmxBP7l94/oYAoFbUMltg/1VpTVWdzmwMBiiUoWd5gTTozS1piMKI/lMuJjQwYGGTiWsICjJL1rcJgqaaFswJHmeKFbQ3jAADRzrLWi42mA1nhKL4tq+7emlS5cirIc+fzt50j20qJlMXco1g4N26BPGTGjRjOugsqcXlqFePQy7LAS1qE09m8SqkNndHNxWTTMFKCw0PNDBdrJAGZrEWo7Qw6lySHu8sA7QB6wckBoLcW3f+dLKlQjroWefOlSL4tgiaqnA4nLNzVC9GnrJUchxDwjZMVJh/FaHZT7UkMERVCGseHkkqgm6GVpNE4Vl6mvv3ixDcUBiBbQMRyQGi2pLaVpCAyt5KbAuJbFm3LPzpcbGlUtXvvAcPrrqBOGmIW+8Biqa4Xwy1Lpi/Z5YIsjqvLCTfF5NYXkihVa7aAkxUvKklUERvYim7lithEU8rouxWQ2ZqSLx0msoqnsbEdbeT/eNFbpLYiodFVZE36Ji25LIALn5raO1yqKqbvLFbHegDbYhVr2rkJzEZTEoQjKnN43G4kQGUejVISyU812CaE9qrHnz7ll174bGxr07nh87o2DNbpW0LlDfvtAaMQCJFioDuaX9jj6ggLe05xor4XzCaBKEZEhOlOR5FdAbCG92KfWjsNYK2J7c9gHo4wNZP4TLwThYLyOqDbuQqPAUmQ6zDNJoVqsDshvQzNRHoYBdWFggAebFqgibAf1igBkEjpgpEiGxFgKZHwrsVlV106FYBfw4tBZbix1FfDIM7V3jYL28aveGXWOJaoSFO4J+v7fFRiVweUuvT8nkk3u1ZqVPWka+FhMu9Gn7/BFjThvSS3i51Keuk1BpVqdIlAiOqBtwQ1L/Fo6uAb2tBYqw1FjzVu3e9fcf+yYqKjifP1ymayWJL0EcvIuL83A+bna5E9mRkKQq6gT/IIw+yjCOs6tetfuvVKKavNX3DxoJSUh1n2TSLijXEKmxuL/v+PO/Ly0lcVpMWhRxt0/ag4Wy3TilOk0bCnPLGndsQefke8tT1pjHO0hKl+nzZPzDaI4R+KiFTYaeBmbo2WmGnjRn6Ll8hv6KkZm/+fwDABHg2TnpuNoAAAAASUVORK5CYII=",self.location).href,icon2x:new URL(""+new URL("google-play-2x.70382080.png",import.meta.url).href,self.location).href,link:"https://play.google.com/store/apps/details?id=com.azure.authenticator&hl=en_US&gl=US"},{icon:new URL("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJYAAAAtCAMAAAB70mJmAAADAFBMVEWZmZmysrK2trazs7OioqJqamqtra2vr69HcEyUlJS/v7+ioqKWlpaioqK5ublubm6ampq5ubmfn5+dnZ27u7tbW1ujo6O5ubmWlpaWlpazs7OsrKygoKCDg4Orq6utra20tLSkpKS2traioqK4uLipqalycnLDw8OJiYmnp6e6urpeXl65ublYWFiysrKvr69+fn6vr68AAAD///8gICBNTU0YGBgFBQU0NDQ1NTUBAQEDAwMCAgIGBgYaGhoHBwf+/v4EBAT9/f0KCgoLCwsfHx8ODg4dHR0PDw9eXl6urq75+fkICAgTExMlJSUuLi5jY2MQEBAnJyfs7Ow4ODhkZGQREREzMzPIyMiGhoYWFhZTU1OYmJhKSkrR0dEsLCwJCQlbW1uZmZkZGRn4+Pi9vb2MjIxQUFCvr6/X19fr6+srKytxcXHh4eH39/etra3AwMD8/Py2trYxMTHOzs5WVlYiIiJYWFgbGxtJSUlMTEyioqLx8fE3NzdGRkZiYmIMDAwhISEqKiqOjo5+fn6mpqZmZma4uLjt7e0oKCjS0tLT09P7+/tAQEDPz88NDQ3ExMSBgYE5OTlubm7GxsbU1NQkJCQUFBRDQ0M2NjbY2NjLy8vl5eWsrKy0tLRZWVnu7u709PSqqqrNzc1VVVU9PT16enri4uJ4eHioqKjz8/M8PDzd3d2FhYXm5uY7OztcXFw6Ojq5ubmfn59ycnJfX18cHBy+vr63t7eJiYm1tbU+Pj5ISEgtLS3k5OTy8vKhoaH6+vqRkZEjIyM/Pz/Dw8NoaGigoKCPj4+wsLB2dnaWlpb29vZgYGDg4OClpaXp6enn5+fMzMzq6uowMDDHx8d/f3/KysqdnZ3Z2dlqamrBwcHc3NxCQkLo6Oienp6bm5uQkJAyMjJlZWV0dHSnp6eIiIhSUlJFRUWKioq8vLzV1dV8fHyCgoLv7+91dXW6urp3d3fFxcXj4+OUlJRvb29OTk6Dg4NnZ2ezs7NpaWlsbGy/v7+xsbGTk5Pa2trphz7oAAAAMnRSTlPhdzB90vuUpQDwC87ryhP93xfS3B7+sizW1EeZwfGKrlbPIr8bvvoG6KM6/Uj+iaTwokGyJ44AAAgkSURBVFjD5dhnVFTXFgfwSfKSN8nrvZfk9f7ef49emN5ghj4UYWiCdAETuggBKUoRGBSpiqFK791eYwWxYhQLdg2K2FtM8mFQcYYAK7qWs9bbH8+cc+a3zt337HMui83+2Vs/ZBlOfP87b/yYzWaxf/mLn2zgGE4kGr3569fZrNd/bsyFQYUk5g9/ZP0q0sBUgOjPr7F+ZAeDi/g/sd72NjyW8TdYb8+crIPM0gBZihu+rrptwiz31cKvSkePDrleU43yq6avPy75OqxmtTRTj1V1rH3V4Bz+xCNmqK10m9w1wol6mpzkISVV8DVYQUuIipN0W53LGc8dK2zAGFdu4EuMhEhXYFuS5LCJezODGLUV5FmuHMAq/hIHkBjfTdGyBA6VSXwoPML9vQHAdKv6pORcW5G/NyBodeVMn8V4EZEbo8/iw/bmI9zpdjsSydt8Q/R4F9+tQ9YWtmruHMSoHT3PPGgPKcICv6FUDjoPxt4cFgLg7fnUK9cfKXn9R1bZArBe2pRsunDeZnW5EnfKdz2wnjbLbh7RwXRMxLIcrVJEzEDNYPbxxWcHwzy66y2XLmP29iNGrSzM82AuDEFuNGufv2nuI+zIEwKwXrIe13w97+dxzmY4AcD5HjnOrfRu/SJcsfJh/eCdabPi37dYexgTshQa1/A8O8wYFjqFVK2JrXlsKwuZg6sfIEat7DzqiMYwwfmPrjXMj84rRIxGCKBZw0GJxup+iExRsR0AOtaKkJIqyR92MKru3xsbOQ2WzMS6gA+PAXermTY2XTqP0TnAMWpviEv0wRbBxbXyhICVhXs0A5A/ZW0fzlE+9lPmqroyShKWViVUDQsBbJsdKdq6m9kRIlNEbAeAR4MuWlZO19GSbCvBlCzbhWENtyqSs2yt4vcOBx46tjPrudf4xokw35024KoGy32zgEWfOeZkFEJm7org07gcZiu41x1gns9L/vh0RCQiI1LLU4UA+A8Hy0db0RngKRzNAYDWjE/kLRckiYPGUC013xw1Fcv6gy1ERDSirigjIiIK3DN+T3VxKrIWAeClr+sCYMXhivItwecoUaBAdhQPovBmK8DUwc7EEbx0hwIOAwCSpNVCwDGRz2yTAwA//TDP0YQryJeBn18fNNVqCdtIL9Iuv+pdntso1lNZXLR91SzrBv3FOp3wymviLKmeqtpGbxifP70zmiA7QfJSWFv1F8tcr3Ad/qS/0XTqyTk1D3KXrrpj+uIsXq0+a43eqGVEI+umnPusWpxZuolmewOQJTIvwmLM9VnOuoOUN32q6epUU8sCSFMSFK5S8QCH1M9cXmi1FuuzFvN0Bq3epLlC3c+eDU/wLNO4gidHHpsD0panGUvDT/5FMr4zwwUAgUg3U410c+uMPmuuic6gq7SzfqQ0DgCaG+8qzU6bX2nlA9sG7puu/zzAy1+7+bZ+GDpW6OTH11Jg8r1CgO+06IJ5srsnwK+8F57kd9sKCLpq/uCKA39y1iN9lnTg+eUy9aWHypV0HgCW09p2i95MKi4BssrmOo/4WFDZNREACGfTx8Y8AHDREIkzxcvAW7hRnHZIWueXDf5m8jtCxxSIX7GlYV9otf/kLIdSfVfprOfytWikyQMXaTQBwCyxT3FNTomGTgTBYSSz9Pa69Y+p7hIAYEcdbbzdLAIEcbtoXsl6axTuz9zqYTdQtuUOuEN0qrg92DRqSe+e6K5roRXRk7Icj+izaCR5fMJ2UJgMl8v22wDoE4cGc4GTgXQdxmm00xMwqaALDAAIVHPFlOaWCEBFwzMBQS196gh49pPGG25U18IFrlO5JVBwUDp/UhYWTcCifePukvI28ouKyvmCggGY0akgALJRWsV3spdGAsAayhs7vW8LVm+htugnKR/VQB0A0CIuy4Ib5doCnj0UG1kyf85BWjQ5a0P1BKyhcdllc4BGDhw45UOPLQEzmmcCgBtL3ZZO9hYLtPm28ekRuGBZLy1/wjIe0a5JYW/oJbjRbgHgqCGpVCqViqlxchb/ir7qVM64DsvJfrSnJyyCmjY8ZUlqqYd5wrpODc9uDKbdFMsbYzmlic0AYIGPhTu8yJwBbCMotk+lUqlmhU/OQv5sXZXYedxiiXZTu6fIkinaTzsAMwoMB+ASQckwshd3AuBtJt9ntV2wW8ta4Q0IM7QV4zod8BhjiQJo6wTldQIWKkd0WIPjL3pJG8V9ACAfpXIBzKR0Rg5mT2ZZDIzsaTQacN+vrQDK9dE8SNyL6RFQIg10ALi76MRZwE5D/aIxFs5Ji915AE82JYtZ5ENERFt6Q4mI6ET9+F9TqFqb/1V0Kx1m4tC6B861H9JOOYzs6f3cNW63SG0CACdLM2q9Ag5RiAIoCqSKodWwiyBNTUcuHTMCd0jLKthN+2MHnGv9mKlYkA8cIh+Nn2v8ufKmUIuj8c99e3IrK9fu4kX7AithRht3NRGleUUDRvY+n2eIqbfHSVui1GVE4qZ2OwCixhGS9gHGH9URlbWtBrhnymIZAFDsLZaSeFO/bEoWmLiFM7y5AAQ28/2fv6pLguLG8llkE9cFM9oXtaGlM04EwMjeYoEicuHlsaMs12pdSZ/r2CHdcl1npRBA9va+vu2mAJAYZ61NKibdf46rsRJTs6YfY2+idq6xN/ElxP8DK+1lsr4tfIHxSedTnp67XI4HJ74klsO7rG85Gd5Hyku/Y732psjQVAW/+T3rBz+dn21YKpfvvfUOi/3e3/77rxmGE3f/8dfffpfNYrPf+ee///NNg4n/vfH3v7DZXwI75LkTWG9+ygAAAABJRU5ErkJggg==",self.location).href,icon2x:new URL(""+new URL("apple-app-store-2x.794e0a2f.png",import.meta.url).href,self.location).href,link:"https://apps.apple.com/us/app/microsoft-authenticator/id983156458"}]}]);return(c,r)=>c.totpHasBeenCreated?(a(),l("div",xe,[Ye,i("div",Me,[i("img",{src:`data:image/png;base64,${c.totpQrCode}`,alt:"qr code",class:"h-[200px] w-[200px]"},null,8,Ne)]),i("div",Ee,[i("p",Qe,q(c.totpSecret),1)])])):(a(),l("div",Le,[Ie,i("p",qe,[y(" Use Google or Microsoft Authenticator on your mobile, or any other TOTP generator to create tokens. "),i("a",{href:e(O),class:"primary",target:"_blank"}," Read more ",8,Re)]),i("div",Ge,[(a(!0),l(x,null,Q(e(U),n=>(a(),l("div",{key:n.name,class:"mx-2 flex w-full flex-col items-center justify-start rounded p-4 shadow-lg"},[i("div",Ke,[i("h3",Se,q(n.name),1)]),Be,i("img",{src:n.icon,alt:"",class:"my-3 w-12"},null,8,De),(a(!0),l(x,null,Q(n.stores,u=>(a(),l("div",{key:u.link,class:"mt-1 max-w-[85%]"},[i("a",{href:u.link,target:"_blank"},[i("img",{src:u.icon,srcset:`${u.icon}, ${u.icon2x} 2x`,alt:""},null,8,Ve)],8,Fe)]))),128))]))),128))]),We]))}}),Pe=["onSubmit"],je={key:0,class:"pb-2 pt-1"},Je=P({__name:"UserFormUpdatePassword",props:{username:{},password:{}},emits:["success"],setup(T,{emit:C}){const O=T,U=X(),c=b(!1),r=b(null),n=V({password:"",passwordConfirm:"",isSubmitting:!1,isSubmitted:!1}),u={password:[{type:"string"},{required:!0,message:"Password is required"},{min:8,message:"Password must not be less than 8 characters"}],passwordConfirm:[{type:"string",required:!0},{validator(h,m,L,R,D){const g=[];return m!==R.password&&g.push("Password did not match"),g}}]},{pass:S,errorFields:B}=te(n,u);_(()=>U.showNewPassForm,h=>c.value=h);async function k(){if(n.isSubmitted=!0,r.value=null,S.value){const{hasErrors:h,message:m,data:L}=await U.updateUserPassword(O.username,O.password,n.password);h.value?r.value=m.value:(c.value=!1,C("success",L))}}const Y=K(()=>({title:"Update Password",actions:{submit:{text:"Update Password",action:k}}}));return(h,m)=>{const L=H,R=ee,D=Ue;return a(),f(ge,{to:"body"},[I(D,we({modelValue:e(c),"onUpdate:modelValue":m[2]||(m[2]=g=>Te(c)?c.value=g:null),size:"max-w-[400px] overflow-hidden rounded",title:"Update Password"},e(Y)),{default:W(()=>{var g,G;return[i("form",{class:"w-full",onSubmit:$(k,["prevent"])},[I(L,{modelValue:e(n).password,"onUpdate:modelValue":m[0]||(m[0]=t=>e(n).password=t),"error-message":e(n).isSubmitted?(g=e(B))==null?void 0:g.password:"",class:"my-2 w-full",label:"Password",type:"password"},null,8,["modelValue","error-message"]),I(L,{modelValue:e(n).passwordConfirm,"onUpdate:modelValue":m[1]||(m[1]=t=>e(n).passwordConfirm=t),"error-message":e(n).isSubmitted?(G=e(B))==null?void 0:G.passwordConfirm:"",class:"my-2 w-full",label:"Password Confirm",type:"password"},null,8,["modelValue","error-message"]),e(r)?(a(),l("div",je,[I(R,{"alert-message":e(r),"alert-type":e(z).ERROR},null,8,["alert-message","alert-type"])])):w("",!0)],40,Pe)]}),_:1},16,["modelValue"])])}}});var o=(T=>(T.O_AUTH="OAuth",T.LOGIN="Login",T.TOTP="Totp",T.TWO_FACTOR_AUTHENTICATION="2FA",T))(o||{});const Ze=["onSubmit"],He={class:"pb-6 text-3xl"},Xe={key:1},_e={key:0},$e={key:0,class:"text-sm"},et={key:1,class:"text-sm"},tt={key:2,class:"text-sm"},st={class:"mt-6 flex items-center justify-start"},ot={key:0,class:"flex flex-grow justify-end"},bt=P({__name:"index",async setup(T){let C,O;const U=b(!0),c=b(),r=b(o.LOGIN),n=X(),u=ye(),S=be(),B=K(()=>!!n.disableAnimation),k=([C,O]=he(()=>n.getAuthProvider()),C=await C,O(),C);async function Y(){const s=await n.getAuthExtSettings();if(!s){t.isSubmitted=!1;return}u.set("token_lifetime",t.tokenLifetime),u.set("auth_provider",k),u.set("auth_provider_login_uri",s.login_uri),location.href=s.authorize_url}async function h(s=!1){j.value=!1;const A=await n.login(t.username,t.password,t.tokenLifetime);A?await J(A):t.isSubmitted=!1}async function m(){await n.sendTwoFactorAuthToken(t.username,t.password,t.token,t.tokenLifetime)?G():t.isSubmitted=!1}function L(){n.errors=[],r.value=o.LOGIN,t.username=null,t.password=null,t.tokenLifetime=null,t.token=null,v.sendTo=null,v.deliveryMethod=null}async function R(){const s=await n.createTotpSecret();s?(d.qr=s.qr,d.secret=s.secret,d.hasBeenCreated=!0):t.isSubmitted=!1}function D(){r.value=o.TWO_FACTOR_AUTHENTICATION,d.qr=null,d.secret=null,d.hasBeenCreated=!1}function g(){n.errors=[],r.value=o.LOGIN,t.username=null,t.password=null,t.tokenLifetime=null,t.token=null}function G(){B.value?S.replace("/dashboard"):S.replace("/")}const t=V({username:"",password:"",tokenLifetime:null,token:null,isSubmitted:!1}),se=b([{text:"1 hour",value:3600},{text:"24 hours",value:86400},{text:"7 days",value:604800},{text:"14 days",value:1209600},{text:"30 days",value:2592e3}]),j=b(!1),v=V({sendTo:null,deliveryMethod:null}),d=V({qr:null,secret:null,hasBeenCreated:!1}),oe=K(()=>{let s;switch(r.value){case o.O_AUTH:case o.LOGIN:s="Login";break;case o.TWO_FACTOR_AUTHENTICATION:s="Verify it's you";break;case o.TOTP:s="TOTP Initializing";break}return s}),re=K(()=>{let s;switch(r.value){case o.LOGIN:s="Login";break;case o.O_AUTH:s=`Login with ${k}`;break;case o.TWO_FACTOR_AUTHENTICATION:s="Verify";break;case o.TOTP:s=d.hasBeenCreated?"Log in with TOTP":"Initialize TOTP now";break}return s}),ae=K(()=>{let s;switch(r.value){case o.O_AUTH:s={tokenLifetime:{type:"number",required:!0}};break;case o.LOGIN:s={username:{type:"string",required:!0},password:{type:"string",required:!0},tokenLifetime:{required:!0}};break;case o.TWO_FACTOR_AUTHENTICATION:s={token:{type:"string",required:!0}};break;case o.TOTP:s={};break}return s}),{pass:M,errorFields:F}=te(t,ae);_(M,s=>t.isSubmitted=!1);async function ne(){if(t.isSubmitted=!0,M.value)switch(r.value){case o.O_AUTH:await Y();break;case o.LOGIN:await h();break;case o.TWO_FACTOR_AUTHENTICATION:await m();break;case o.TOTP:d.hasBeenCreated?D():(await R(),t.isSubmitted=!1);break}}const J=async s=>{s!=null&&s.two_fa?(v.sendTo=s.two_fa.send_to,v.deliveryMethod=s.two_fa.delivery_method,s.two_fa.delivery_method==="totp_authenticator_app"&&s.two_fa.totp_key_status==="pending"?r.value=o.TOTP:(r.value=o.TWO_FACTOR_AUTHENTICATION,await Ce(),c.value.inputRef.focus()),t.isSubmitted=!1):G()};function ie(){switch(r.value){case o.TWO_FACTOR_AUTHENTICATION:L();break;case o.TOTP:g();break}}return ve(()=>{k&&k!=="built-in"&&(r.value=o.O_AUTH),u.get("token_lifetime")&&(t.tokenLifetime=u.get("token_lifetime")),U.value=!1}),(s,A)=>{const le=de,N=H,ue=pe,Ae=ze,Z=ee,E=Oe,ce=Je;return a(),l(x,null,[i("form",{class:"w-full max-w-[400px]",onSubmit:$(ne,["prevent"])},[i("h1",He,q(e(oe)),1),e(U)?(a(),f(le,{key:0,"loading-circular-size":42})):(a(),l("div",Xe,[e(r)===e(o).TWO_FACTOR_AUTHENTICATION?(a(),l("div",_e,[e(v).deliveryMethod==="pushover"?(a(),l("p",$e,[y(" We've sent you a verification code via pushover to "),i("b",null,q(e(v).sendTo),1),y(" . Please enter it below. ")])):e(v).deliveryMethod==="totp_authenticator_app"?(a(),l("p",et," Please open the authenticator app on your mobile device and type below the code that is displayed. ")):(a(),l("p",tt,[y(" We've sent you a verification code to "),i("b",null,q(e(v).sendTo),1),y(" . Please enter it below. ")]))])):w("",!0),e(r)===e(o).LOGIN?(a(),f(N,{key:1,modelValue:e(t).username,"onUpdate:modelValue":A[0]||(A[0]=p=>e(t).username=p),"error-message":e(t).isSubmitted?e(F).username:"",label:"Username"},null,8,["modelValue","error-message"])):w("",!0),e(r)===e(o).LOGIN?(a(),f(N,{key:2,modelValue:e(t).password,"onUpdate:modelValue":A[1]||(A[1]=p=>e(t).password=p),"error-message":e(t).isSubmitted?e(F).password:"",class:"mt-2",label:"Password",type:"password"},null,8,["modelValue","error-message"])):w("",!0),e(r)!==e(o).TWO_FACTOR_AUTHENTICATION&&e(r)!==e(o).TOTP?(a(),f(ue,{key:3,modelValue:e(t).tokenLifetime,"onUpdate:modelValue":A[2]||(A[2]=p=>e(t).tokenLifetime=p),modelModifiers:{number:!0},"error-message":e(t).isSubmitted?e(F).tokenLifetime:"",items:e(se),class:"mt-2",label:"Remember me for"},null,8,["modelValue","error-message","items"])):w("",!0),e(r)===e(o).TWO_FACTOR_AUTHENTICATION?(a(),f(N,{key:4,ref_key:"inputTOTP",ref:c,modelValue:e(t).token,"onUpdate:modelValue":A[3]||(A[3]=p=>e(t).token=p),"error-message":e(t).isSubmitted?e(F).token:"",class:"mt-2",label:"Enter your 2FA code"},null,8,["modelValue","error-message"])):w("",!0),e(r)===e(o).TOTP?(a(),f(Ae,{key:5,"totp-has-been-created":e(d).hasBeenCreated,"totp-qr-code":e(d).qr,"totp-secret":e(d).secret},null,8,["totp-has-been-created","totp-qr-code","totp-secret"])):w("",!0),(a(!0),l(x,null,Q(e(n).errors,(p,me)=>(a(),f(Z,{key:`error-${me}`,"alert-message":p,"alert-type":e(z).ERROR},null,8,["alert-message","alert-type"]))),128)),e(j)?(a(),f(Z,{key:6,"alert-type":e(z).SUCCESS,"alert-message":"Your verification code has been resent."},null,8,["alert-type"])):w("",!0),i("div",st,[I(E,{"button-loading":e(t).isSubmitted&&e(M),"button-type":e(ke).SUBMIT,class:"primary"},{default:W(()=>[y(q(e(re)),1)]),_:1},8,["button-loading","button-type"]),e(r)===e(o).TWO_FACTOR_AUTHENTICATION||e(r)===e(o).TOTP?(a(),l("div",ot,[e(r)===e(o).TWO_FACTOR_AUTHENTICATION?(a(),f(E,{key:0,"button-small":"",class:"primary plain",onClick:A[4]||(A[4]=p=>h(!0))},{default:W(()=>[y(" Resend ")]),_:1})):w("",!0),I(E,{"button-small":"",class:"primary plain",onClick:ie},{default:W(()=>[y(" Cancel ")]),_:1})])):w("",!0)])]))],40,Ze),I(ce,{password:e(t).password,username:e(t).username,onSuccess:J},null,8,["password","username"])],64)}}});export{bt as default};
